package rs.etf.ts.calculator;

import rs.etf.ts.storage.ResultStorage;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

class MockCalculatorTests {

    @Test
    void TP01_addition_test() {
        ResultStorage storage = mock(ResultStorage.class);
        when(storage.get()).thenReturn(10);

        Calculator calculator = new Calculator(storage);
        calculator.add(5);

        verify(storage).get();
        verify(storage).set(15);

        //assertEquals(15, calculator.getResult());
    }

    @Test
    void TP_02_subtraction_test() {
        ResultStorage storage = mock(ResultStorage.class);
        when(storage.get()).thenReturn(10);

        Calculator calculator = new Calculator(storage);
        calculator.substract(5);

        // Expected: 5
        // Actual (bug): 9
        verify(storage).get();
        verify(storage).set(5);

        //assertEquals(5, calculator.getResult());
    }

    @Test
    void TP_03_multiplication_test() {
        ResultStorage storage = mock(ResultStorage.class);
        when(storage.get()).thenReturn(4);

        Calculator calculator = new Calculator(storage);
        calculator.multiply(3);

        verify(storage).get();
        verify(storage).set(12);

        //assertEquals(12, calculator.getResult());
    }

    @Test
    void TP_04_division_test() {
        ResultStorage storage = mock(ResultStorage.class);

        Calculator calculator = new Calculator(storage);
        calculator.squareRoot(25);

        verify(storage).set(5);
        verify(storage, never()).get();

        //assertEquals(5, calculator.getResult());
    }

    @Test
    void TP05_isPositive_test() {
        ResultStorage storage = mock(ResultStorage.class);
        when(storage.get()).thenReturn(3);

        Calculator calculator = new Calculator(storage);
        boolean positive = calculator.isPositive();

        verify(storage).get();
        verify(storage, never()).set(anyInt());

        assertTrue(positive);
    }
}
