package rs.etf.ts.calculator;

import org.junit.jupiter.api.*;
import org.junit.jupiter.params.*;
import static org.junit.jupiter.api.Assertions.*;

import rs.etf.ts.storage.InMemoryStorage;
import rs.etf.ts.storage.ResultStorage;

public class CalculatorTests {
    private static Calculator calculator;

    @BeforeAll
    public static void setUp() {
        ResultStorage storage = new InMemoryStorage();
        calculator = new Calculator(storage);
    }

    @BeforeEach
    public void beforeEach() {
        calculator.switchOn();
    }

    @AfterEach
    public void afterEach() {
        calculator.switchOff();
    }

    @Test
    public void additionTest() {
        calculator.add(5);
        assertEquals(5, calculator.getResult());
        calculator.add(-2);
        assertEquals(3, calculator.getResult());
    }

    @Test
    public void subtraction2Test() {
        calculator.substract2(5, 3);
        assertEquals(2, calculator.getResult());
        calculator.substract2(3, -4);
        assertEquals(7, calculator.getResult());
    }

    @Test
    public void multiplicationTest() {
        calculator.setResult(5);
        assertEquals(5, calculator.getResult());
        calculator.multiply(2);
        assertEquals(10, calculator.getResult());
        calculator.multiply(-2);
        assertEquals(-20, calculator.getResult());
    }

    @Test
    public void divisionTest() {
        calculator.setResult(5);
        assertEquals(5, calculator.getResult());
        calculator.divide(2);
        assertEquals(2, calculator.getResult());
        calculator.divide(-1);
        assertEquals(-2, calculator.getResult());
        calculator.clear();
        calculator.divide(2);
        assertEquals(0, calculator.getResult());
    }

    @Test
    public void isPositive() {
        calculator.setResult(5);
        assertTrue(calculator.isPositive());
    }

    @Test
    public void isNegative() {
        calculator.setResult(0);
        assertFalse(calculator.isPositive());
    }
}
