package rs.etf.ts.calculator;
import rs.etf.ts.storage.InMemoryStorage;
import rs.etf.ts.storage.ResultStorage;

import java.util.Scanner;

public class Main {

    public static void main(String[] args) {
        ResultStorage storage = new InMemoryStorage();
        Calculator calculator = new Calculator(storage);
        Scanner in = new Scanner(System.in);

        calculator.switchOn();
        System.out.println("...Switch On...");
       
        calculator.clear();
        System.out.println("Unesite prvi broj");
        int n = in.nextInt();
        calculator.add(n);
                
        System.out.println("Unesite operaciju");
        char o = in.next().charAt(0);
        
        while ( o == '+' || o == '-' ) {
            System.out.println("Unesite novi broj");
            n = in.nextInt();

            if ( o == '+' )
               calculator.add(n);
             else
               calculator.substract(n);
             System.out.println("Rezultat = " + calculator.getResult());
             System.out.println("Unesite operaciju");
             o = in.next().charAt(0);
        }
        
        calculator.switchOff();
        System.out.println("...Switch Off...");
    }
}
