package rs.etf.ts.calculator;
import rs.etf.ts.storage.*;

public class Calculator {

    private final ResultStorage storage;

    public Calculator(ResultStorage storage) {
        this.storage = storage;
    }

    public void add(int n) {
        int result = storage.get();
        result = result + n;
        storage.set(result);
    }

    public void substract(int n) {
        int result = storage.get();
        result = result - 1;        // BUG: should subtract n
        storage.set(result);
    }

    public void substract2(int x, int y) {
        int result = x - y;
        storage.set(result);
    }

    public void multiply(int n) {
        int result = storage.get();
        result = result * n;
        storage.set(result);
    }

    public void divide(int n) {
        int result = storage.get();
        result = result / n;
        storage.set(result);
    }

    public void square(int n) {
        int result = n * n;
        storage.set(result);
    }

    public void squareRoot(int n) {
        n = storage.get();      // BUG: value of n is ignored
        if (n < 0) {
            storage.set(0);
        } else {
            storage.set((int) Math.sqrt(n));
        }
    }

    public void clear() {
        storage.set(0);
    }

    public void switchOn() {
        storage.set(0);
    }

    public void switchOff() {
        storage.set(0);
    }

    public int getResult() {
        return storage.get();
    }

    public void setResult(int n) {
        storage.set(n);
    }

    public boolean isPositive() {
        return storage.get() > 0;
    }
}
