package etf;

import org.junit.jupiter.api.*;
import org.junit.jupiter.params.*;
import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvSource;
import etf.Calculator;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

@TestMethodOrder(MethodOrderer.OrderAnnotation.class)
public class CalculatorTest {
    private static Calculator calculator;

    @BeforeAll
    public static void beforeAll() {
        calculator = new Calculator();
    }

    @BeforeEach
    public void beforeEach() {
        calculator.switchOn();
    }

    @AfterEach
    public void afterEach() {
        calculator.switchOff();
    }

    @Test
    @Order(1)
    public void additionTest() {
        calculator.add(5);
        assertEquals(5, calculator.getResult());
        calculator.add(-2);
        assertEquals(3, calculator.getResult());
    }

    @Test
    @Order(2)
    public void subtractionTest() {
        calculator.substract(5);
        assertEquals(-5, calculator.getResult());
        calculator.substract(-2);
        assertEquals(-3, calculator.getResult());
    }

    @Test
    @Order(3)
    public void subtraction2Test() {
        calculator.substract2(5, 3);
        assertEquals(2, calculator.getResult());
        calculator.substract2(3, -4);
        assertEquals(7, calculator.getResult());
    }

    @Test
    @Order(4)
    public void multiplicationTest() {
        calculator.setResult(5);
        assertEquals(5, calculator.getResult());
        calculator.multiply(2);
        assertEquals(10, calculator.getResult());
        calculator.multiply(-2);
        assertEquals(-20, calculator.getResult());
    }

    @Test
    @Order(5)
    public void divisionTest() {
        calculator.setResult(5);
        assertEquals(5, calculator.getResult());
        calculator.divide(2);
        assertEquals(2, calculator.getResult());
        calculator.divide(-1);
        assertEquals(-2, calculator.getResult());
        calculator.clear();
        calculator.divide(2);
        assertEquals(0, calculator.getResult());
    }

    @ParameterizedTest
    @Order(6)
    @CsvFileSource(resources = "/data.csv", numLinesToSkip = 1)
    public void parameterizedTest(int num, int result) {
        calculator.square(num);
        assertEquals(result, calculator.getResult());
    }

//    @ParameterizedTest
//    @Order(6)
//    @CsvSource({"5,25", "-4,16", "0,0"})
//    public void parameterizedTest(int num, int result) {
//        calculator.square(num);
//        assertEquals(result, calculator.getResult());
//    }

    @Test
    @Order(7)
    @Timeout(value = 1, unit = TimeUnit.SECONDS)
    public void sqrtTest() {
        Assertions.assertTimeoutPreemptively(Duration.ofSeconds(1), () -> {
            calculator.squareRoot(16);
            assertEquals(4, calculator.getResult());
            calculator.squareRoot(0);
            assertEquals(0, calculator.getResult());
        });
    }

    @Test
    @Order(8)
    public void isPositive() {
        calculator.setResult(5);
        assertTrue(calculator.isPositive());
    }

    @Test
    @Order(9)
    public void isNegative() {
        calculator.setResult(-5);
        assertFalse(calculator.isPositive());
    }
}
